varying vec2 		texcoord;
uniform sampler2D 	tex;
uniform vec4		diffuseColor;
varying float		fadeAlpha;
uniform sampler2D 	lmask;
//vec3				one=vec3(1.0,1.0,1.0);
//vec3				hlf=vec3(0.5,0.5,0.5);

float blend1D(float f1, float f2, float a1, float a2, float alpha)
{
	float depth=0.2;
	float ma=max(a1+(1.0-alpha),a2+alpha)-depth;
	
	float b1=max(a1 + (1.0-alpha) - ma,0.0);
	float b2=max(a2 + alpha - ma,0.0);
	
	return (f1*b1 + f2*b2)/(b1+b2);
}

void main()
{
	vec4 color=texture2D(tex,texcoord.st);
	float alpha=texture2D(lmask,texcoord.st).a*fadeAlpha;
	alpha=blend1D(0.0, 1.0, 0.8, color.a, alpha);
	
	gl_FragColor.rgb=(color.rgb*diffuseColor.xyz)+(1.0-clamp(alpha,0.0,1.0));
	gl_FragColor.a=1.0;
}
